import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../common/constant/colors.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/Empty_view.dart';
import '../../../../common/widgets/rx_view.dart';
import '../../../../common/widgets/text.dart';
import '../../../auth/business_logic/auth_controller.dart';
import '../../../home/business_logic/home_controller.dart';
import '../../business_logic/note_controller.dart';
import '../../data/model/note.dart';
import '../widgets/drop_down_notes.dart';
import '../widgets/note_body.dart';

class NotesPage extends StatefulWidget {

  NotesPage({super.key});

  @override
  State<NotesPage> createState() => _NotesPageState();
}

class _NotesPageState extends State<NotesPage> {
  final NoteController noteController = Get.put(NoteController());
  final HomeController homeController = Get.find<HomeController>();

  AuthController authController = Get.find<AuthController>();

  loadData() async{
    await noteController.getNotes({
      'registration_record_id': authController.childrens[homeController.selectedChild.value].id,
      'size': 25
    });
  }

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    loadData();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBar(
          backgroundColor: Colors.transparent,
          leading: IconButton(
            icon: const Icon(Icons.arrow_back),
            color: AppColors.newPrimeColor,
            onPressed: () {
              Navigator.pop(context);
            },
          ),
          title: Center(
            child: HeadTitleText(
              'Notes'.tr.toUpperCase(),
              color: AppColors.newPrimeColor,
              fontFamily: 'alatsi',
            ).padding(
                padding: EdgeInsets.symmetric(horizontal: Get.width * .02)),
          ),
        ),
        body: Column(children: [
          DropDownNotes().center().expanded(1),
          SizedBox(
              width: Get.width * .85,
              child: Obx(() {
                return RxView(
                    rxFuture: noteController.notesState,
                    onRetry: () {
                      noteController.getNotes(
                        {
                          'registration_record_id': authController.childrens[homeController.selectedChild.value].id,
                          'size': 25,
                        },
                      );
                    },
                    child: noteController.notesState.result.isEmpty
                        ? Padding(
                          padding: EdgeInsets.symmetric(vertical: Get.height * .2),
                          child: const EmptyView(),
                        )
                        : ListView.builder(
                            padding: const EdgeInsets.only(top: 10),
                            itemCount: noteController.notesState.result.length,
                            itemBuilder: (BuildContext context, index) {
                              NoteResponse note =
                                  noteController.notesState.result[index];
                              return NoteBodyWidget(
                                note: note,
                              ).onTap(() {
                              });
                            }));
              })).expanded(9)
        ]),
      ),
    );
  }
}
