import 'package:intl/intl.dart';

class NotificationResponse {
  NotificationResponse({
    required this.id,
    required this.title,
    required this.read,
    required this.type,
    required this.date,
    this.body,
  });

  String id;
  String title;
  String? body;
  int read;
  String type;
  DateTime date;

  factory NotificationResponse.fromJson(Map<String, dynamic> json) =>
      NotificationResponse(
        id: json["id"].toString(),
        title: json["title"],
        body: json['body'] ?? '',
        read: json['read'],
        type: json['type'],
        date: convertToDateTime(json["created_at"]),
      );

  factory NotificationResponse.zero() => NotificationResponse(
        id: '',
        title: '',
        read: 0,
        type: '',
        date: DateTime.now(),
      );

  static List<NotificationResponse> fromJsonList(
    Map<String, dynamic> json,
    String key,
  ) {
    List<NotificationResponse> notifications = [];

    if (json[key] == null) {
      return [];
    }

    try {
      json[key].forEach(
        (notification) => notifications.add(
          NotificationResponse.fromJson(notification),
        ),
      );
    } catch (e) {
      print(e);
    }

    return notifications;
  }

  static DateTime convertToDateTime(String date) {
    DateFormat dateFormat = DateFormat('yyyy-MM-dd');
    DateTime s = dateFormat.parse(date);

    return s;
  }
}
