import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../../../common/constant/colors.dart';
import '../../../../common/constant/font.dart';
import '../../../../common/widgets/text.dart';
import '../../data/model/notification.dart';

class NotificationDetails extends StatelessWidget {
  final NotificationResponse notificationModel;

  NotificationDetails({super.key, required this.notificationModel});
  String formattedDate = '';

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        Container(
          margin: const EdgeInsets.only(top: 10),
          // height: 35,
          height: Get.height * .1,
        decoration: BoxDecoration(
            color: AppColors.quizItem,
            borderRadius: BorderRadius.circular(20)
        ),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              SizedBox(
                  width: Get.width / 2,
                  child: Text(
                    notificationModel.title.tr,
                    style: TextStyle(
                        fontFamily: AppFonts.regular,
                        fontSize: 15,
                        color: AppColors.appBlack.withOpacity(0.5)),
                  )).paddingSymmetric(horizontal: 10),
              NormalText(
                '${notificationModel.date.day}-${notificationModel.date.month}-${notificationModel.date.year}',
                textColor: AppColors.secondaryColor.withOpacity(0.5),
              ).paddingSymmetric(horizontal: 10),
            ],
          ),
        ).paddingSymmetric(horizontal: 20),
        
      ],
    );
  }
}
