import '../../../../../../features/restaurant/data/model/meal.dart';

class BuffetCardModel {
  BuffetCardModel({
    required this.dailyLimit,
    required this.balance,
  
  });
  late num dailyLimit;
  late final num balance;
  late String buffet_note;
  late String ordered_meals;
  late List<MealClass> meals;
  late num student_id;

  BuffetCardModel.fromJson(Map<String, dynamic> json) {
    dailyLimit = json['daily_limit'] ?? 0 ;
    balance = json['balance'] ?? 0;
    buffet_note = json['buffet_note'] ?? '';
    ordered_meals = json['ordered_meals'] ?? '';
    student_id = json['student_id'] ?? 0;
    meals = json['meal'] ?? [];

  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    data['daily_limit'] = dailyLimit;
    data['balance'] = balance;
    return data;
  }

   static List<BuffetCardModel> fromJsonList(Map<String, dynamic> json, String key) {
    List<BuffetCardModel> studentMeals = [];
    if (json[key] == null) {
      return [];
    }
    try {
      json[key].forEach((meal) {
        studentMeals.add(BuffetCardModel.fromJson(meal));
      });
    } catch (e) {
      print(e.toString());
    }
    return studentMeals;
  }

  factory BuffetCardModel.zero(String date, String name) => BuffetCardModel(
    dailyLimit: 0, balance: 0,  );
}
