class PurchaseItem {
  PurchaseItem({
    required this.id,
    required this.product,
    required this.quantity,
    required this.totalAmount,
    required this.type,
    required this.date,
  });
  late final int id;
  late final String product;
  late final int quantity;
  late final num totalAmount;
  late final String type;
  late final DateTime date;

  PurchaseItem.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    product = json['product'];
    quantity = json['quantity'];
    totalAmount = json['total_amount'];
    type = json['type'];
    date = DateTime.parse(json['date']);
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    data['id'] = id;
    data['product'] = product;
    data['quantity'] = quantity;
    data['total_amount'] = totalAmount;
    data['type'] = type;
    data['date'] = date;
    return data;
  }
}
