

class StudentMeal {
  StudentMeal({
    required this.date,
    required this.registrationRecordId,
    required this.meal,
  });

  String date;
  int registrationRecordId;
  MealClass meal;

  factory StudentMeal.fromJson(Map<String, dynamic> json ) => StudentMeal(
    
        date: json["date"],
        registrationRecordId: json["registration_record_id"],
        meal: MealClass.fromJson(json["meal"]),
      );

  Map<String, dynamic> toJson() => {
        // "date":
        //     "${date.year.toString().padLeft(4, '0')}-${date.month.toString().padLeft(2, '0')}-${date.day.toString().padLeft(2, '0')}",
        "registration_record_id": registrationRecordId,
        "meal": meal.toJson(),
      };
  static List<StudentMeal> fromJsonList(Map<String, dynamic> json, String key) {
    List<StudentMeal> studentMeals = [];
    if (json[key] == null) {
      return [];
    }
    try {
      json[key].forEach((meal) {
        studentMeals.add(StudentMeal.fromJson(meal));
      });
    } catch (e) {
      print(e.toString());
    }
    return studentMeals;
  }

  factory StudentMeal.zero(String date, String name) => StudentMeal(
      date: date, registrationRecordId: 0, meal: MealClass.zero(name: name));
}

class MealClass {
  MealClass({
    required this.id,
    required this.name,
    required this.image,
    required this.description,
    required this.status,
    required this.price,
    required this.days,
  });

  int id;
  String name;
  String image;
  String description;
  String status;
  int price;
  List<String> days;
  bool? check = false;

  factory MealClass.fromJson(Map<String, dynamic> json) => MealClass(
        id: json["id"],
        name: json["name"],
        image: json["image"],
        description: json["description"],
        status: json["status"],
        price: json["price"],
        days: List<String>.from(json["days"].map((x) => x)),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "image": image,
        "description": description,
        "status": status,
        "price": price,
        "days": List<dynamic>.from(days.map((x) => x)),
      };
  factory MealClass.zero({String? name}) => MealClass(
      id: 0,
      name: name ?? '',
      image: '',
      description: '',
      status: '',
      price: 0,
      days: []);
}
