
import 'package:get/get.dart';
import 'package:intl/intl.dart';
import '../../../../../../common/constant/apis.dart';
import '../../../../../../core/errors/custom_exception.dart';
import '../../../../../../core/network/http.dart';
import '../../../../../../features/restaurant/data/model/get_meals.dart';
import '../../../../../../features/restaurant/data/model/meal.dart';
import '../../../../../../features/restaurant/data/model/meal_request.dart';
import '../../../../../../features/purchase/api_res.dart';
import '../../../../../../features/purchase/models/buffet_card_model.dart';
import '../../../../../../features/purchase/models/purchase_item_model.dart';
import '../../../../../../features/purchase/models/day_purchase_model.dart';

class RestaurantWebService {
  Future<List<StudentMeal>> getStudentMeals({
    required String registrationRecordId,
    required DateTime dateFrom,
    required DateTime dateTo,
  }) async {
    Request request = Request(
      EndPoints.studentMeals(registrationRecordId),
      RequestMethod.get,
      queryParams: {
        "date_from": DateFormat('yyyy-MM-dd').format(dateFrom),
        "date_to": DateFormat('yyyy-MM-dd').format(dateTo),
      },
      authorized: true,
    );
    Map<String, dynamic> response = await request.sendRequest();
    List<StudentMeal> data =
        StudentMeal.fromJsonList(response, 'data');
    return data;
  }

  Future<int> getStudentBalance({
    required String registrationRecordId,
  }) async {
    Request request = Request(
      EndPoints.studentBalance(registrationRecordId),
      RequestMethod.get,
      authorized: true,
    );
    Map<String, dynamic> jsonData = await request.sendRequest();
    int balance = jsonData['data']['balance'];
    // print("balance");
    // print(balance);
    return balance;
  }

  Future<int> getStudentDailyLimet({
    required String registrationRecordId,
  }) async {
    Request request = Request(
      EndPoints.studentBalance(registrationRecordId),
      RequestMethod.get,
      authorized: true,
    );
    Map<String, dynamic> jsonData = await request.sendRequest();
    int balance = jsonData['data']['daily_limit'];
    // print("daily_limit");
    // print(balance);
    return balance;
  }
    Future<ApiResponse> getBuffetCard({
    required String childId,
  }) async {
    

    try {
      Request request = Request(
      EndPoints.studentBalance(childId),
      RequestMethod.get,
      authorized: true,
    );

      Map<String, dynamic> response = await request.sendRequest();

      // print(response);


      //  List<dynamic> buffet = response['data'];

      // print('ligwkgnrkkngkrngerngergerngperngpergperngperngpknerpggnergnerpngpe');

      // print('ligwkgnrkkngkrngerngergerngperngpergperngperngpknerpggnergnerpngpe');
      // print(buffet);
      // print('ligwkgnrkkngkrngerngergerngperngpergperngperngpknerpggnergnerpngpe');

      // print('ligwkgnrkkngkrngerngergerngperngpergperngperngpknerpggnergnerpngpe');

      // List<BuffetCardModel> purchaseList = List.generate(
      //     buffet.length, (index) => BuffetCardModel.fromJson(buffet[index]));

      return ApiResponse(data: response);
    } on GenericException catch (e) {
      return ApiResponse(errorMessage: e.errorMessage);
    } catch (e) {
      return ApiResponse(errorMessage: 'unknown_error'.tr);
    }
  }

  Future<ApiResponse> getPurchaseByDay({
    required int childId,
    required DateTime date,
  }) async {
  
    try {
      Map<String, String> params = {
        'registration_record_id': childId.toString(),
        'date': DateFormat('yy/MM/dd').format(date),
      };

      Request request = Request(
        EndPoints.getPurchaseByDay,
        RequestMethod.get,
        queryParams: params,
        authorized: true,
      );

      Map<String, dynamic> response = await request.sendRequest();

      List<dynamic> purchase = response['data'];
      List<PurchaseItem> purchaseList = List.generate(
          purchase.length, (index) => PurchaseItem.fromJson(purchase[index]));

      return ApiResponse(data: purchaseList);
    } on GenericException catch (e) {
      return ApiResponse(errorMessage: e.errorMessage);
    } catch (e) {
      return ApiResponse(errorMessage: 'unknown_error'.tr);
    }
  }

  Future<ApiResponse> getPurchaseByWeek({
    required int childId,
  }) async {


    try {
      Map<String, String> params = {
        'registration_record_id': childId.toString(),
        'week': 'true',
      };

       Request request = Request(
      EndPoints.getPurchaseByDay,
      RequestMethod.get,
      authorized: true,
      queryParams: params,
    );

      Map<String, dynamic> response = await request.sendRequest();

      List<dynamic> purchase = response['data'];
      List<DayPurchaseModel> dayPurchaseList = List.generate(purchase.length,
          (index) => DayPurchaseModel.fromJson(purchase[index]));

      return ApiResponse(data: dayPurchaseList);
    } on GenericException catch (e) {
      return ApiResponse(errorMessage: e.errorMessage);
    } catch (e) {
      return ApiResponse(errorMessage: 'unknown_error'.tr);
    }
  }


  Future<void> sendDailyLimit(int childId, int newDailyLimit) async{
    Map<String, dynamic> body = {
      '_method': 'put',
      'daily_limit': newDailyLimit,
    };
    Request request = Request(
      EndPoints.updateDailyLimit(childId),
      RequestMethod.post,
      body: body,
      authorized: true,
    );
    Map<String, dynamic> response = await request.sendRequest();
    // print('#@#@#@#@#@#@ ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ #@#@#@##@#@#@#');
    // print(response);
    // print('#@#@#@#@#@#@ ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ #@#@#@##@#@#@#');
  }

  updateDailyLimit({required int childId, required num newDailyLimit}) async {
    try {
      Map<String, dynamic> body = {
        '_method': 'put',
        'daily_limit': newDailyLimit,
      };
      Request request = Request(
      EndPoints.updateDailyLimit(childId),
      RequestMethod.post,
      body: body,
      authorized: true,
      );
      Map<String, dynamic> response = await request.sendRequest();
      return ApiResponse(data: ' ');
    } on GenericException catch (e) {
      return ApiResponse(errorMessage: e.errorMessage);
    } catch (e) {
      return ApiResponse(errorMessage: 'unknown_error'.tr);
    }
  }

  //home
  Future<StudentMeal> getLatestMeal(
      String registrationRecordId, DateTime date) async {
    Request request = Request(
      EndPoints.studentMeals(registrationRecordId),
      RequestMethod.get,
      queryParams: {
        "date": DateFormat('yyyy-MM-dd').format(date),
      },
      authorized: true,
    );
    Map<String, dynamic> response = await request.sendRequest();
    // print(request);
    // print("EEEEEEEEEEEEEee");
    // print(response);
    List<StudentMeal> data =
        StudentMeal.fromJsonList(response, "data");
    if (data.isNotEmpty) {
      return data.first;
    } else {
      return StudentMeal.zero('', '');
    }
    // return MealModel.fromJsonList(response);
  }

Future<BuffetCardModel> LategetBuffetCard(
       {required String registrationRecordId}) async {
    Request request = Request(
      EndPoints.studentBalance(registrationRecordId),
      RequestMethod.get,
      
      authorized: true,
    );
    Map<String, dynamic> response = await request.sendRequest();
    // print(request);
    // print("EEEEEEEEEEEEEee");
    // print(response);
    BuffetCardModel data =
        BuffetCardModel.fromJson(response);
        return data;
    // if (data.isNotEmpty) {
    //   return data.first;
    // } else {
    //   return BuffetCardModel.zero('', '');
    // }
  }

  Future<MealDays> getMeals({
    required String registrationRecordId,
    required DateTime dateFrom,
    required DateTime dateTo,
  }) async {
    Request request = Request(
      EndPoints.getMeals(registrationRecordId, dateFrom, dateTo),
      RequestMethod.get,
      // queryParams: {
      //   "date_from": DateFormat('yyyy-MM-dd').format(dateFrom),
      //   "date_to": DateFormat('yyyy-MM-dd').format(dateTo),
      // },
      authorized: true,
    );
    Map<String, dynamic> response = await request.sendRequest();

    MealDays data = MealDays.fromJson(response);
    // print("YYYYYYYYYYYyyy");

    // print(response);
    return data;
    // List<StudentMeal> data =
    //     StudentMeal.fromJsonList(response, 'student_meals');
    // return data;
  }

  Future<MealDays> getAllMeals({
    required String day,
    
  }) async {
    Request request = Request(
      EndPoints.getAllMeals(day),
      RequestMethod.get,
      // queryParams: {
      //   "date_from": DateFormat('yyyy-MM-dd').format(dateFrom),
      //   "date_to": DateFormat('yyyy-MM-dd').format(dateTo),
      // },
      authorized: true,
    );
    Map<String, dynamic> response = await request.sendRequest();

    MealDays data = MealDays.fromJson(response);
    // print("YYYYYYYYYYYyyy");

    // print(response);
    return data;
    // List<StudentMeal> data =
    //     StudentMeal.fromJsonList(response, 'student_meals');
    // return data;
  }

  Future<void> sendMeal(MealRequest mealRequest) async {
    Request request = Request(EndPoints.addMeal, RequestMethod.post,
        body: mealRequest.toJson(), authorized: true);
    Map<String, dynamic> response = await request.sendRequest();
    // print(response);
    // print("CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC");
    // print(mealRequest.toJson());
    // print("HHHHHHHHHHHHHHHHHHHHHHHHHHhh");
    // print(mealRequest.toJson());
  }

}
