import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../common/widgets/snack_bar_widget.dart';
import '../../../../../../features/restaurant/presentation/widgets/show_meal.dart';

import '../../../../common/constant/colors.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/circular_progress_indicator.dart';
import '../../../../core/routing/routing_manager.dart';
import '../../business_logic/restaurant_controller.dart';
import '../widgets/school_button.dart';
import '../widgets/week_day_widget.dart';

class MealsMenuPage extends StatelessWidget {
  final RestaurantController restaurantController =
      Get.put(RestaurantController());
  MealsMenuPage({super.key});
 
  @override
  Widget build(BuildContext context) {
     restaurantController.getMeals();
     // restaurantController.getAllMeals();
    return SafeArea(
      child: Scaffold(
        body: Padding(
          padding: const EdgeInsets.symmetric(vertical: 0),
          child: Column(
            children: [
              SizedBox(
                  width: Get.width,
                  child: Obx(() {
                    if (restaurantController.getMealsState.loading) {
                      return const CircularProgressIndicatorWidget();
                    } else {
                      return ListView.builder(
                          itemCount: restaurantController
                              .getMealsState.result.day.length,
                          itemBuilder: (BuildContext context, index) {
                            return ConstrainedBox(
                                constraints:
                                    const BoxConstraints(maxHeight: 200),
                                child: Column(
                                  children: [
                                    WeekDayWidget(
                                      date: restaurantController.date[index],
                                      mealDays: restaurantController
                                          .getMealsState.result.day[index],
                                    ).expanded(1),
                                    SizedBox(
                                        width: Get.width,
                                        child: ShowMeal(
                                          mealsModel: restaurantController
                                              .getMealsState
                                              .result
                                              .day[index]
                                              .meals,
                                          date:
                                              restaurantController.date[index],
                                          // i: index,
                                        )).expanded(4)
                                  ],
                                ));
                          });
                    }
                  })).expanded(9),
              Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  SchoolButton(() {
                    RoutingManager.back();
                  }, 'Back', AppColors.secondaryColor),
                  const SizedBox(
                    width: 20,
                  ),
                  Obx(() {
                    return SchoolButton(
                      () async {
                        await restaurantController.sendMeal(
                          onSuccess: () async {
                            RoutingManager.back();
                          await  restaurantController.getStudentMeals();
                            snackBarWidget('', 'Added successfully');
                            restaurantController.studentMeals.clear();
                            restaurantController.mealRequest.clear();
                            restaurantController.getMealsOfDay.clear();
                          },
                        );
                      },
                      'Save'.tr,
                      AppColors.primeColor.withOpacity(0.8),
                      isLoading: restaurantController.sendMealState.loading,
                    );
                  })
                ],
              ).expanded(1)
            ],
          ),
        ),
      ),
    );
  }
}
