import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:get/get.dart';
import '../../../../../../common/extensions/widget.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../../features/restaurant/presentation/screens/restaurant_home.dart';
import '../../../../../../helpers/date_helpers.dart';
import '../../../../common/constant/colors.dart';
import '../../business_logic/restaurant_controller.dart';

class RestaurantScreenMiddleware extends GetMiddleware {
  late int balance;
  @override
  Widget onPageBuilt(Widget page) {
    final RestaurantController restaurantController = Get.find<RestaurantController>();
    final AuthController authController = Get.find<AuthController>();
    final HomeController homeController = Get.find<HomeController>();
    restaurantController.studentMeals.clear();
    restaurantController.setRegistrationRecord(authController.childrens[homeController.selectedChild.value].id,);
    WidgetsBinding.instance.addPostFrameCallback((_) async {
      restaurantController.studentMeals.clear();
      await restaurantController.getStudentMeals();
      await restaurantController.getStudentBalance(authController.childrens[homeController.selectedChild.value].id);
      restaurantController.studentMeals.clear(); 
    });
    restaurantController.studentMeals.clear();
    return super.onPageBuilt(page);
  }
}

class RestaurantScreen extends StatefulWidget {
  RestaurantScreen({super.key});
  @override
  State<RestaurantScreen> createState() => _RestaurantScreenState();
}

class _RestaurantScreenState extends State<RestaurantScreen> with TickerProviderStateMixin {
  HomeController homeController = Get.find<HomeController>();
  AuthController authController = Get.find<AuthController>();
  final RestaurantController restaurantController = Get.find<RestaurantController>();
  late final TabController _tabController;
  DateHerlpers? dateHelpers;
  void loadData() async {
    restaurantController.studentMeals.clear();
    await restaurantController.getStudentMeals();
    await restaurantController.getStudentBalance(authController.childrens[homeController.selectedChild.value].id);
  }

  @override
  void initState() {
    super.initState();
    _tabController = TabController(length: 5, vsync: this);
    loadData();
  }

  @override
  Widget build(BuildContext context) {
    return RefreshIndicator(
      color: AppColors.newPrimeColor,
      backgroundColor: AppColors.newSecondaryColor,
      onRefresh: () async {
        loadData();
      },
      child: Container(
        decoration: const BoxDecoration(
            color: Color.fromRGBO(238, 238, 238, 1), 
            image: DecorationImage(
                image: AssetImage('asset/images/backGroundLogIn1.png'),
                fit: BoxFit.cover)),
        child: Scaffold(
          backgroundColor: Colors.transparent,
          body: Padding(
            padding: EdgeInsets.only(left: 10.0, right: 10.0, top: Get.height * .0),
            child: Obx((){
              return Column(
                children: [
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: [
                      HeadTitleText(
                        size: 20,
                        'Balance :'.tr.toUpperCase(),
                        color: AppColors.newPrimeColor,
                      ).center().padding(
                          padding: const EdgeInsets.only(right: 10)),
                      NormalText(
                        restaurantController.getBalanceNew.result.toString(),
                        fontFamily: 'alatsi',
                        textColor:
                        Colors.black,
                        size: 20,
                      ).center(),
                    ],
                  ),
                  Expanded(child: RestaurantHome()),
                ],
              );
            })
          ),
        ),
      )
    );
  }
}
