import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../common/constant/domain.dart';
import '../../../../common/constant/colors.dart';
import '../../../../common/extensions/date.dart';
import '../../data/model/meal.dart';

class RestaurantMealCardWidget extends StatelessWidget {
  final VoidCallback onChange;
  final StudentMeal studentMeal;
  const RestaurantMealCardWidget(this.studentMeal,
      {super.key, required this.onChange});
  @override
  Widget build(BuildContext context) {
    String words = studentMeal.meal.image;
    List<String> wordL = words.split("/");
    String image = wordL.sublist(1, wordL.length).join("/");
    return Column(
      children: [
        SizedBox(
          height: 80,
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Container(
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    Padding(
                      padding: const EdgeInsets.only(top: 2.0,right: 4.0),
                      child: Container(
                        height: 60.0,
                        width: 60.0,
                        decoration: BoxDecoration(
                          image: DecorationImage(
                            image: studentMeal.meal.check == false
                                ? const AssetImage('asset/images/meal.png')
                                : NetworkImage('${Domain.domain}storage/$image')
                                    as ImageProvider,
                            fit: BoxFit.cover,
                          ),
                          shape: BoxShape.circle,
                        ),
                      ),
                    ),
                    const SizedBox(
                      width: 15,
                    ),
                    Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          DateTime.parse(studentMeal.date).toDay().tr,
                          style: TextStyle(
                            fontSize: 15,
                            fontWeight: FontWeight.bold,
                            color: AppColors.secondaryColor,
                          ),
                        ),
                        // const SizedBox(
                        //   height: 1,
                        // ),
                        Text(
                          studentMeal.date,
                          style: TextStyle(
                            fontSize: 12,
                            color: AppColors.appBlack.withOpacity(0.5),
                          ),
                        ),
                        const SizedBox(
                          height: 4,
                        ),
                        Text(
                          studentMeal.meal.name.tr,
                          style: TextStyle(
                              fontSize: 15,
                              fontWeight: FontWeight.bold,
                              color: AppColors.secondaryColor),
                        ),
                      ],
                    ),
                  ],
                ),
              ),
              //  MealOverViewWidget(mealModel),
              InkWell(
                onTap: onChange,
                child: Container(
                  // margin: const EdgeInsets.only(left: 40, right: 40),
                  height: 30,
                  width: 100,
                  color: studentMeal.meal.check == false
                      ? AppColors.primeColor
                      : AppColors.appGreen.withOpacity(0.8),
                  child: Center(
                    child: Text(
                      studentMeal.meal.check == false
                          ? 'select'.tr
                          : 'Change'.tr,
                      style: const TextStyle(
                          fontWeight: FontWeight.bold, color: Colors.white),
                    ),
                  ),
                ),
              )
            
            ],
          ),
        ),
        const Divider(
          thickness: 1,
        ),
      ],
    );
  }
}
