import 'package:flutter/material.dart';
import '../../../../../../common/widgets/circular_progress_indicator.dart';

import '../../../../common/constant/colors.dart';
import '../../../../../../common/extensions/widget.dart';

class SchoolButton extends StatelessWidget {
  final VoidCallback ontTap;
  final String title;
  final Color? color;
  final bool isLoading;
  const SchoolButton(this.ontTap, this.title, this.color,
      {super.key, this.isLoading = false});
  @override
  Widget build(BuildContext context) {
    return InkWell(
      onTap: ontTap,
      child: Container(
        // margin: const EdgeInsets.only(top: 10),
        height: 40,
        width: 160,
        decoration: BoxDecoration(
          color: color ?? AppColors.primeColor.withOpacity(0.8),
          borderRadius: BorderRadius.circular(10),
        ),
        child: Center(
          child: isLoading==true
              ? Padding(
                padding: const EdgeInsets.symmetric(horizontal: 5),
                child: Row(mainAxisAlignment: MainAxisAlignment.center,crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      Text(
                        title,
                        style: const TextStyle(
                          color: Colors.white,
                          fontWeight: FontWeight.bold,
                        ),
                      ).padding(padding: const EdgeInsets.only(right: 5)),
                      const CircularProgressIndicatorWidget(
                        size: 0.7,
                        color: Colors.white,
                      )
                    ],
                  ),
              )
              : Text(
                  title,
                  style: const TextStyle(
                    color: Colors.white,
                    fontWeight: FontWeight.bold,
                  ),
                ),
        ),
      ),
    );
  }
}
