import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../features/restaurant/data/model/get_meals.dart';

import '../../../../common/constant/colors.dart';
import '../../../../common/constant/domain.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/text.dart';

class SelectMealWidget extends StatefulWidget {
  final Function() onTap;
  final MealModel meal;
  final bool isSelected;

  const SelectMealWidget({
    super.key,
    required this.onTap,
    required this.meal,
    this.isSelected = false,
  });

  @override
  _SelectMealWidgetState createState() => _SelectMealWidgetState();
}

class _SelectMealWidgetState extends State<SelectMealWidget> {
  @override
  Widget build(BuildContext context) {
   String words = widget.meal.image;
    List<String> wordL = words.split("/");
    String image = wordL.sublist(1, wordL.length).join("/");
    return Scaffold(
      body: GestureDetector(
        onTap: widget.onTap,
        child: Container(
            height: MediaQuery.of(context).size.height,
            width: 180,
            margin: const EdgeInsets.all(8),
            decoration: BoxDecoration(
                color: widget.meal.selected == true
                    ? AppColors.appGreen.withOpacity(0.8)
                    : Colors.white,
                border: Border.all(color: AppColors.appGreen),
                borderRadius: BorderRadius.circular(10)),
            child: Column(
              children: [
                Container(
                  height: 100.0,
                  width: 180.0,
                  decoration: BoxDecoration(
                    borderRadius: const BorderRadius.only(
                        topLeft: Radius.circular(10),
                        topRight: Radius.circular(10)),
                    image: DecorationImage(
                      image: NetworkImage(
                        '${Domain.domain}storage/$image',
                      ),
                      fit: BoxFit.fill,
                    ),
                    shape: BoxShape.rectangle,
                  ),
                ),
                Container(
                  child: Column(children: [                    
                TextTitle(
                  widget.meal.price.toString(),
                  size: 15,
                  textColor: widget.meal.selected == true
                      ? Colors.white
                      : AppColors.appGreen,
                ).padding(padding: const EdgeInsets.only(top: 5,)),
                    SizedBox(
                    height: 50,
                     child: TextTitle(
                        widget.meal.name.tr,
                        size: 12,
                        textColor: widget.meal.selected == true
                            ? Colors.white
                            : AppColors.appGreen,
                      ).padding(padding: const EdgeInsets.only(left: 20, top: 5)),
                   ),
                  ]),
                ),
                    // color: Colors.red,
                   
              ],
            )),
      ),
    );
  }
}
