import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../../features/restaurant/data/model/get_meals.dart';
import '../../../../../../features/restaurant/presentation/widgets/select_meal.dart';

import '../../business_logic/restaurant_controller.dart';

class ShowMeal extends StatefulWidget {
  List<MealModel> mealsModel;
  String date;


  ShowMeal({super.key, required this.mealsModel, required this.date});

  @override
  State<ShowMeal> createState() => _ShowMealState();
}

class _ShowMealState extends State<ShowMeal> with AutomaticKeepAliveClientMixin {
  AuthController authController = Get.find<AuthController>();

  HomeController homeController = Get.find<HomeController>();

  // final int index;
  final RestaurantController restaurantController =
      Get.put(RestaurantController());

  @override
  Widget build(BuildContext context) {
    return Container(
      height: MediaQuery.of(context).size.height,
      width: MediaQuery.of(context).size.width,
      margin: const EdgeInsets.all(1),
      child: Expanded(
        child: GridView.count(
          childAspectRatio: 450 / 500,
          crossAxisCount: 2,
          shrinkWrap: true,
          children: List.generate(widget.mealsModel.length, (index){
            return SizedBox(
              height: 500,
              width: 500,
              child: SelectMealWidget(
                onTap: () {
                  restaurantController.onChangeColor(index, widget.mealsModel[index], widget.date);
                  print(widget.date);
                  print("IIIIIIIIIIIIiii");
                },
                meal: widget.mealsModel[index],
                ///////new line
                isSelected: restaurantController.isSelected(index),
              ),
            );
          } ),
          ),
      //   child: GridView.builder(
          
      //     gridDelegate: const SliverGridDelegateWithFixedCrossAxisCount(crossAxisCount: 2),
      //     physics: const BouncingScrollPhysics(),
      //     shrinkWrap: false,
      //     scrollDirection: Axis.vertical,
          
      //     padding: EdgeInsets.all(5),
          
      //     itemBuilder: (BuildContext context, index) {
      //       return SizedBox(
      //         height: 200,
      //         width: 200,
      //         child: SelectMealWidget(
                  
      //           onTap: () {
      //             restaurantController.onChangeColor(index, widget.mealsModel[index], widget.date);
                    
      //             print(widget.date);
      //             print("IIIIIIIIIIIIiii");
      //           },
      //           meal: widget.mealsModel[index],
      //           ///////new line
      //           isSelected: restaurantController.isSelected(index),
      //         ),
      //       );
      //     },
      //     itemCount: 1,
      //   ),
      // ),
    ));
  }
  
  @override
  // TODO: implement wantKeepAlive
  bool get wantKeepAlive => true;
}
