import 'package:flutter/material.dart';

import '../../../../common/widgets/ignore.dart';
import '../../../../common/widgets/text.dart';
import 'package:get/get.dart';

import '../../business_logic/setting_controller.dart';

class LanguageSwitch extends StatelessWidget {
  final SettingController settingController = Get.put(SettingController());
  final String title;
  final VoidCallback onTap;

  final Color backGroundColor;
  final bool ignoring;
  final Color borderColor;
  final Color textColor;
  final double shadow;

  LanguageSwitch(
      {super.key,
      required this.title,
      required this.onTap,
      required this.backGroundColor,
      required this.ignoring,
      required this.borderColor,
      required this.textColor,
      required this.shadow});

  @override
  Widget build(BuildContext context) {
    return IgnoreWidget(
      ignoring: ignoring,
      child: InkWell(
        onTap: onTap,
        child: Container(
          alignment: Alignment.center,
          margin: const EdgeInsets.symmetric(horizontal: 10),
          width: 160,
          height: 35,
          decoration: BoxDecoration(
              boxShadow: [
                BoxShadow(
                  color: Colors.black.withOpacity(shadow),
                  spreadRadius: 5,
                  blurRadius: 7,
                  offset: const Offset(1, 1),
                ),
              ],
              border: Border.all(color: borderColor),
              color: backGroundColor,
              borderRadius: BorderRadius.circular(10)),
          child: NormalText(
            title,
            textColor: textColor,
          ),
        ),
      ),
    );
  }
}
