import 'package:get/get.dart';
import 'package:rx_future/rx_future.dart';
import '../../../../../../common/widgets/snack_bar_widget.dart';
import '../../../../../../features/variable/data/model/variable_class.dart';
import '../../../../../../features/variable/data/remote_source/variable_service.dart';

class VariableController extends GetxController{

  RxFuture<List<VariableModel>> variablePersonalState = RxFuture([]);
  RxFuture<List<VariableModel>> variableAllState = RxFuture([]);
  VariableService variableService = VariableService();

  Future<void> getPersonalVariableInfo(String registrationRecord,String filter) async{
    await variablePersonalState.observe(
        (_) async{
          return variableService.getVariableInfo(registrationRecord, filter);
        },
      onError: (p0){
          snackBarWidget("Ooop's somthing wrong", p0.toString());
      }
    );
  }

  Future<void> getAllVariableInfo(String registrationRecord,String filter) async{
    await variableAllState.observe(
            (_) async{
          return variableService.getVariableInfo(registrationRecord, filter);
        },
        onError: (p0){
          snackBarWidget("Ooop's somthing wrong", p0.toString());
        }
    );
  }
}