class VariableModel {

  String studentName;
  String variableName;
  String className;
  String eduClassName;
  String variableTye;
  String createdAt;
  String notes;
  String desc;

  VariableModel({
    required this.studentName,
    required this.variableName,
    required this.className,
    required this.eduClassName,
    required this.variableTye,
    required this.createdAt,
    required this.notes,
    required this.desc
    });

  factory VariableModel.zero() =>
      VariableModel(
          studentName: '',
          variableName: '',
          className: '',
          eduClassName: '',
          variableTye: '',
          createdAt: '',
          notes: '',
          desc: ''
      );

  factory VariableModel.fromJson(Map<String, dynamic> json) =>
      VariableModel(
          studentName: json["student_name"],
          variableName: json["variable_name"],
          className: json["grade"],
          eduClassName: json["edu_class"],
          variableTye: json["variable_type"],
          createdAt: json["date"],
          notes: json['notes'] ?? '--',
          desc: json['desc'] ?? '--'
      );

  static List<VariableModel> fromJsonList(
      Map<String, dynamic> json,
      String key
      ) {
    List<VariableModel> variables = [];
    try {
      if (json[key] == null) {
        return [];
      }
      json[key].forEach(
              (v) =>
              variables.add(
                VariableModel.fromJson(v),
              )
      );
    } catch (e) {
      print(
          'Error from Variable Model Error from Variable Model Error from Variable Model');
      print(e);
    }
    return variables;
  }

}