import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/extensions/widget.dart';
import '../../../../../../features/variable/business_logic/variable_controller.dart';
import '../../../../../../features/variable/presentation/screens/allVariable.dart';
import '../../../../../../features/variable/presentation/screens/personalVariable.dart';

import '../../../../common/widgets/text.dart';

class HomeVariable extends StatefulWidget {
  const HomeVariable({super.key});

  @override
  State<HomeVariable> createState() => _HomeVariableState();
}

class _HomeVariableState extends State<HomeVariable> {


  VariableController variableController = Get.put(VariableController());



  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBar(
          backgroundColor: Colors.transparent,
          leading: IconButton(
            icon: const Icon(Icons.arrow_back),
            color: AppColors.newPrimeColor,
            onPressed: () {
              Navigator.pop(context);
            },
          ),
          title: Center(
            child: HeadTitleText(
              'Variable'.tr.toUpperCase(),
              color: AppColors.newPrimeColor,
              fontFamily: 'alatsi',
              size: 20,
            ).padding(padding: EdgeInsets.symmetric(horizontal: Get.width * .25)),
          ),
        ),
        body:  DefaultTabController(
            initialIndex: 1,
            length: 2,
            child: TabBarView(
              children: [
                SubVarTabBar(),
              ],
            ),
          )
      ),
    );
  }
}


class SubVarTabBar extends StatefulWidget {
  const SubVarTabBar( {super.key});


  @override
  State<SubVarTabBar> createState() => _SubTabBarState();
}

class _SubTabBarState extends State<SubVarTabBar> with TickerProviderStateMixin{

  late final TabController _tabController;

  @override
  void initState() {
    super.initState();
    _tabController = TabController(length: 2, vsync: this);
  }

  @override
  void dispose() {
    _tabController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Column(
      children: <Widget>[
        Padding(
          padding: EdgeInsets.symmetric(horizontal: MediaQuery.of(context).size.width * 0.05 ,vertical: MediaQuery.of(context).size.width * 0.02 ),
          child: Container(
            height: MediaQuery.of(context).size.height * 0.035,
            decoration: BoxDecoration(
                color: AppColors.newSecondaryColor,
                borderRadius: BorderRadius.circular(20)
            ),
            child: TabBar.secondary(
              labelColor: Colors.white,
              unselectedLabelColor: AppColors.newPrimeColor,
              dividerColor: Colors.transparent,
              indicator: BoxDecoration(
                  color: AppColors.newPrimeColor,
                  borderRadius: BorderRadius.circular(20)
              ),
              controller: _tabController,
              tabs: <Widget>[
                Tab(
                    child: HeadTitleText(
                      "Personal".tr,
                      fontFamily: 'alatsi',
                      size: 15,
                    )
                ),
                Tab(
                    child: HeadTitleText(
                      "General".tr,
                      fontFamily: 'alatsi',
                      size: 15,
                    )
                ),

              ],
            ),
          ),
        ),
        Expanded(
          child: TabBarView(
            controller: _tabController,
            children: <Widget>[
              PersonalVariable(),
              AllVariable()
            ],
          ),
        )
      ],
    );
  }
}
