import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:get/get.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/constant/font.dart';
import '../../../../../../common/extensions/widget.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../features/variable/data/model/variable_class.dart';

class VariableBody extends StatelessWidget {

  final VariableModel tempVar;

  const VariableBody({
    super.key,
    required this.tempVar
  });

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: EdgeInsets.symmetric(horizontal: Get.width * .05, vertical: Get.height*.01),
      child: Container(
        height: Get.height * .2,
        decoration: BoxDecoration(
          color: AppColors.quizItem,
          borderRadius: BorderRadius.circular(20)
        ),
        child: Padding(
          padding: EdgeInsets.symmetric(horizontal: Get.width * .02),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.spaceEvenly,
            children: [
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceAround,
                children: [
                  Container(
                    width: Get.width * 0.14,
                    height: Get.height * .10,
                    color: Colors.transparent,
                    child: Image(
                        image: tempVar.variableTye == "POSITIVE"
                            ? const AssetImage('asset/icons/medal.png')
                            : tempVar.variableTye == "NEGATIVE"
                            ? const AssetImage('asset/icons/red-card.png')
                            : const AssetImage('asset/icons/administration.png')
                    ),
                  ),
                  Column(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: [
                      SizedBox(
                        width: Get.width * .3 ,//125,
                        height: Get.height * .06,//50,
                        child: Center(
                          child: AutoSizeText(
                            tempVar.variableName,
                            style: TextStyle(
                                fontFamily: AppFonts.alatsi,
                                fontWeight: FontWeight.normal
                            ),
                            maxFontSize: 15,
                            minFontSize: 10,
                            maxLines: 2,
                          ),
                        ),
                      ),
                      Container(
                        // color: Colors.red,
                        width: Get.width * .3 ,//125,
                        height: Get.height * .06,//50,
                        child: Center(
                          child: AutoSizeText(
                            tempVar.studentName,
                            style: TextStyle(
                                // fontSize: 20,
                                fontFamily: AppFonts.alatsi,
                                fontWeight: FontWeight.normal
                            ),
                            minFontSize: 10,
                            maxFontSize: 15,
                            maxLines: 2,
                          ),
                        ),
                      )
                    ],
                  ).padding(padding: EdgeInsets.symmetric(horizontal: Get.height * .01)),
                  SizedBox(width: Get.width * .05,),
                  Container(
                    width: Get.width * .2 ,//125,
                    height: Get.height * .06,//50,
                    // color: Colors.yellow,
                    child: Center(
                      child: AutoSizeText(
                        tempVar.createdAt,
                        style: TextStyle(
                            fontFamily: AppFonts.alatsi,
                            fontWeight: FontWeight.normal
                        ),
                        maxFontSize: 15,
                        minFontSize: 10,
                        maxLines: 2,
                      ),
                    ),
                  ),
                ],
              ),
              HeadTitleText(
                tempVar.desc == 'null' ? '--' : tempVar.desc,
                size: 15,
                color: Colors.black,
                fontFamily: AppFonts.alatsi,
              )
            ],
          ),
        ),
      ),
    );
  }
}
