import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:get/get.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/constant/font.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../features/wallet/business_logic/wallet_controller.dart';
import '../../../../../../features/wallet/data/model/financeOrderModel.dart';
import '../../../../../../features/wallet/presentation/widget/toPay.dart';

class FinancialOrderWallet extends StatefulWidget {
  const FinancialOrderWallet({super.key});

  @override
  State<FinancialOrderWallet> createState() => _FinancialOrderWalletState();
}

class _FinancialOrderWalletState extends State<FinancialOrderWallet> {
  WalletController walletController = Get.find<WalletController>();
  loadData()async{
    await walletController.getFinanceToPayInfo();
  }
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    loadData();
  }

  @override
  Widget build(BuildContext context) {
    return SizedBox(
      width: Get.size.width,
      height: Get.size.height,
      child: Padding(
        padding: EdgeInsets.only(top: Get.height * .02),
        child: Obx(() {
          return walletController.financeToPayState.loading
              ? Center(
                child: CircularProgressIndicator(
                  backgroundColor: AppColors.quizItem,
                  color: AppColors.newPrimeColor,
                ),
              )
              : walletController.financeToPayState.result.isEmpty
              ? Padding(
            padding: EdgeInsets.symmetric(horizontal: Get.width * 0.1),
            child: Center(
              child: HeadTitleText(
                "OrderToPay".tr,
                size: 40,
                color: AppColors.newPrimeColor,
                fontFamily: AppFonts.alatsi,
              ),
            ),
          )
              : ListView.builder(
              itemCount: walletController.financeToPayState.result.length,
              itemBuilder: (context, index) {
                FinanceModel finance = walletController.financeToPayState.result[index];
                return ToPayFinance(toPayFinance: finance).paddingOnly(bottom: MediaQuery.sizeOf(context).width * 0.05);
              });
        })
      ),
    );
  }
}
