import 'package:flutter/material.dart';
import 'package:webview_flutter/webview_flutter.dart';
import 'package:get/get.dart';
import '../../../../../core/local storage/local_storage.dart';
import '../../../auth/business_logic/auth_controller.dart';

class ChargeScreen extends StatefulWidget {
  @override
  State<ChargeScreen> createState() => _ChargeScreenState();
}

class _ChargeScreenState extends State<ChargeScreen> {
  late final WebViewController controller;
  bool tokenInserted = false;
  String? typeUser;
  @override
  void initState() {
    super.initState();
    LocalStorage storage = LocalStorage();
    typeUser = storage.userTypeUser;
    final String allowedDomain = "lbbis.incentive-dev.com";
    final String token = '${Get.find<AuthController>().token}';
    controller = WebViewController()
      ..setJavaScriptMode(JavaScriptMode.unrestricted)
      ..setNavigationDelegate(
        NavigationDelegate(
          onNavigationRequest: (request) {
            if (!request.url.contains(allowedDomain)) {
              return NavigationDecision.prevent;
            }
            return NavigationDecision.navigate;
          },
          onPageFinished: (url) async {
            if (!tokenInserted) {
              tokenInserted = true;
              await controller.runJavaScript("""
                localStorage.setItem('type_app', '$typeUser');
                localStorage.setItem('access_token', '$token');
                localStorage.setItem('theme', 'light');
              """);
              Future.delayed(const Duration(milliseconds: 300), () {
                controller.reload();
              });
            }
          },
        ),
      )
      ..loadRequest(Uri.parse("https://lbbis.incentive-dev.com/lbbisChargeScreen?token=$token"
      ));
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        if (await controller.canGoBack()) {
          controller.goBack();
          return false;
        }
        return true;
      },
      child: WebViewWidget(controller: controller),
    );
  }
}