import 'package:get/get.dart';
import 'package:rx_future/rx_future.dart';
import '../../../../../../features/calender/data/models/lesson.dart';
import '../../../../../../features/weekly_class/data/model/lesson_details_model.dart';
import '../../../../../../features/weekly_class/data/model/weekly_class.dart';
import '../../../../../../features/weekly_class/data/remote_source/weekly_class_service.dart';
import '../../../../../../features/weekly_class/data/remote_source/weekly_class_service.dart';
import '../../../../../../features/weekly_class/data/remote_source/weekly_class_service.dart';

import '../data/remote_source/weekly_class_service.dart';
import '../data/remote_source/weekly_class_service.dart';

class WeeklyClassController extends GetxController {

  WeeklyClassService weeklyClassService = WeeklyClassService();
  RxFuture<WeeklyClassModel> subjectTableState =
      RxFuture(WeeklyClassModel.zero());
  List<DailySubject> subjects = [];


  Future<void> getSubjectTable(String registrationRecordId,
      {String? day}) async {
    Future.delayed(Duration.zero, () async {
      await subjectTableState.observe(
        (p0) async {
          return await weeklyClassService.getWeeklyClass(registrationRecordId);
        },
        onSuccess: (value) {
          if (day != null) {
            subjects = value.getDailyClass(day);
          }
        },
      );
    });
  }


  RxFuture<List<LessonModel>> getLessonsState = RxFuture(<LessonModel>[]);

  Future<void> getLessons(
      String responsibilityId, String createdFrom, String createdTo) async {
    await getLessonsState.observe(
      (value) async {
        return await weeklyClassService.getLessons(
            responsibilityId, createdFrom, createdTo);
      },
      onSuccess: (value) {
        lessonDetailsState =
      RxFuture(LessonDetailsModel.zero());
        if (value.isNotEmpty) {
          getLessonDetails(value.first.id);
        }
      },
    );
  }

  RxFuture<LessonDetailsModel> lessonDetailsState =
      RxFuture(LessonDetailsModel.zero());

  Future<void> getLessonDetails(int id) async {
      print("detail state");
      print(lessonDetailsState.toString());
    await lessonDetailsState.observe((value) async {
      return await weeklyClassService.lessonDetails(id);
    });
  }
}

