
import '../../../../../../common/constant/apis.dart';
import '../../../../../../features/calender/data/models/lesson.dart';
import '../../../../../../features/weekly_class/data/model/lesson_details_model.dart';

import '../../../../core/network/http.dart';
import '../model/new_weekly_class.dart';

class NewWeeklyClassService {
  Future<NewWeeklyClassModel> getNewWeeklyClass(
      String registrationRecordId) async {
    Request request = Request(
      EndPoints.newSubjectTable(registrationRecordId),
      RequestMethod.get,
      authorized: true,
    );
    Map<String, dynamic> response = await request.sendRequest();

    return NewWeeklyClassModel.fromJson(response);
  }

  Future<List<LessonModel>> getLessons(
      String responsibilityId, String createdFrom, String createdTo) async {
    Request request = Request(
      EndPoints.getLessons,
      RequestMethod.get,
      authorized: true,
      queryParams: {
        "responsibility_id": responsibilityId,
        "from": createdFrom,
        "to": createdTo
      },
    );
    Map<String, dynamic> response = await request.sendRequest();
    return LessonModel.fromJsonList(response);
  }

  Future<LessonDetailsModel> lessonDetails(int id) async {
    Request request = Request(
      EndPoints.lessonDetails(id),
      RequestMethod.get,
      authorized: true,
    );
    Map<String, dynamic> response = await request.sendRequest();
    LessonDetailsModel lesson = LessonDetailsModel.fromJson(response["data"]);
    return lesson;
  }
}