import 'dart:convert';

import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:get/get.dart';
import 'package:intl/intl.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/extensions/widget.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/home/common/constant.dart';
import 'package:http/http.dart' as http;
import '../../../../../../features/weekly_class/business_logic/new_weekly_class_controller.dart';
import '../../../../../../features/weekly_class/data/model/new_weekly_class.dart';
import '../../../../../../helpers/date_helpers.dart';

import '../../../../core/network/api.dart';
import '../../../../core/routing/routing_manager.dart';
import '../../../calender/data/models/subject_model.dart';

class ClassWidget extends StatefulWidget {
  // final SubjectModel subjectModel;
  final newDailySubject newSubjects;
  final int index;
   const ClassWidget({super.key, required this.newSubjects, required this.index});

  @override
  State<ClassWidget> createState() => _ClassWidgetState();
}

class _ClassWidgetState extends State<ClassWidget> {

  NewWeeklyClassController newWeeklyController =
  Get.find<NewWeeklyClassController>();

  String nameDay = DateFormat('EEEE').format(DateTime.now()).toLowerCase();

  int? ind;

  @override
  Widget build(BuildContext context) {
    if(nameDay == 'sunday'){
      ind=0;
    }else if(nameDay == 'monday'){
      ind=1;
    }else if(nameDay == 'tuesday'){
      ind=2;
    }else if(nameDay == 'wednesday'){
      ind=3;
    }else if(nameDay == 'thursday'){
      ind=4;
    }
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        const Icon(CupertinoIcons.book, size: 30,),//.padding(padding: EdgeInsets.symmetric(horizontal: 0)),
        SizedBox(
          width: Get.width * .1 ,//50,
          height: Get.height * .03,//25,
          child: HeadTitleText(
            widget.newSubjects.order.toString(),
            fontFamily: AppFonts.alatsi,
            size: 10,
            color: AppColors.newPrimeColor,
          ).padding(padding: EdgeInsets.only(left: Get.width * .025, right: Get.width * .025, top: Get.height * .008)),
        ),
        SizedBox(
          width: Get.width * .17 ,//70,
          height: Get.height * .065,//50,
          child: Center(
            child: AutoSizeText(
              widget.newSubjects.subject.toString(),
              style: TextStyle(
                fontSize: 20,
                fontFamily: AppFonts.alatsi
              ),
              maxLines: 1,
            ),
          )
          // HeadTitleText(
          //   newSubjects.subject.toString(),
          //   fontFamily: AppFonts.alatsi,
          //   size: 10,
          //   color: AppColors.newPrimeColor,
          // ),
        ),
        SizedBox(
          width: Get.width * .17 ,//70,
          height: Get.height * .025,//25,
          child: HeadTitleText(
            widget.newSubjects.teacher.toString(),
            fontFamily: AppFonts.alatsi,
            size: 15,
            color: AppColors.newPrimeColor,
          ).padding(padding: EdgeInsets.symmetric(horizontal: Get.width * 0.02)),
        ),
      ],
    ).onTap(() async {
      print(DateHerlpers.getWeekDates(DateTime.now()));
      try{
        await newWeeklyController.getLessons(
            newWeeklyController.subjectMap[nameDay]!.subjects[widget.index].id.toString(),//subjects[index].id,
            DateHerlpers.getWeekDates(DateTime.now())[ind!].toString().substring(0, 10),
            DateHerlpers.getWeekDates(DateTime.now())[ind!].toString().substring(0, 10));
        RoutingManager.to(RoutesName.classPage, arguments: newWeeklyController.subjectMap[nameDay]!.subjects[widget.index].subject);
      }catch(e){
        print(e);
      }
    });
  }
}
