import 'dart:convert';

import 'package:flutter/cupertino.dart';
import 'package:shared_preferences/shared_preferences.dart';

class DataStore {
  static Future<String?> getToken() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    String? token = prefs.getString(SharedPreferenceServiceKeys.token);
    return token;
  }

  static Future<Map?> getChildrenListData() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    String? childrenData =
        prefs.getString(SharedPreferenceServiceKeys.children);
    if (childrenData == null) return null;
    return jsonDecode(childrenData);
  }

  static Future<void> setToken(String token) async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    await prefs.setString(SharedPreferenceServiceKeys.token, token);
  }

  static Future<void> clearToken() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    await prefs.remove(SharedPreferenceServiceKeys.token);
    await prefs.remove(SharedPreferenceServiceKeys.children);
    await prefs.remove(SharedPreferenceServiceKeys.fcmTokenId);
    await prefs.remove(SharedPreferenceServiceKeys.page);
    await prefs.remove(SharedPreferenceServiceKeys.phoneNumber);
    await prefs.remove(SharedPreferenceServiceKeys.password);
  }

  static Future<void> setChildrenListData(var data) async {
    String jsonData = json.encode(data);
    SharedPreferences prefs = await SharedPreferences.getInstance();
    await prefs.setString(SharedPreferenceServiceKeys.children, jsonData);
  }

  static Future<int?> getFCMTokenId() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    int? token = prefs.getInt(SharedPreferenceServiceKeys.fcmTokenId);
    return token;
  }

  static Future<void> setFCMTokenId(int id) async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    await prefs.setInt(SharedPreferenceServiceKeys.fcmTokenId, id);
  }

  static Future<void> setLanguage(Locale lang) async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    await prefs.setString(SharedPreferenceServiceKeys.Lang, lang.languageCode);
  }

  static Future<void> setCurrentPage(String page) async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    await prefs.setString(SharedPreferenceServiceKeys.page, page);
  }

  static Future<void> setPhoneNumber(String phoneNumber) async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    await prefs.setString(SharedPreferenceServiceKeys.phoneNumber, phoneNumber);
  }

  static Future<void> setPassword(String password) async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    await prefs.setString(SharedPreferenceServiceKeys.password, password);
  }

  static Future<void> saveData(String key, dynamic value) async =>
      await CacheHelper.saveData(key: key, value: value);
  static dynamic getData(String key) => CacheHelper.getData(key);

  static Future<String?> getCurrentPage() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    String? page = prefs.getString(SharedPreferenceServiceKeys.page);
    return page;
  }

  static Future<String?> getLanguage() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    String? language = prefs.getString(SharedPreferenceServiceKeys.Lang);
    return language;
  }

  static Future<String?> getPhoneNumber() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    String? phoneNumber =
        prefs.getString(SharedPreferenceServiceKeys.phoneNumber);
    return phoneNumber;
  }

  static Future<String?> getPassword() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    String? password = prefs.getString(SharedPreferenceServiceKeys.password);
    return password;
  }
}

class SharedPreferenceServiceKeys {
  static const String token = 'token';
  static const String children = 'children';
  static const String fcmTokenId = 'fcmTokenId';
  static const String Lang = 'lang';
  static const String phoneNumber = 'phoneNumber';
  static const String password = 'password';
  static const String page = 'page';
  static const String base = 'base';
}

class CacheHelper {
  static SharedPreferences? _pref;
  static init() async {
    _pref = await SharedPreferences.getInstance();
  }

  static Future<bool> saveData({
    required String? key,
    required dynamic value,
  }) async {
    if (value is String) return await _pref!.setString(key ?? '', value);
    if (value is int) return await _pref!.setInt(key ?? '', value);
    if (value is bool) return await _pref!.setBool(key ?? '', value);
    return await _pref!.setDouble(key ?? '', value);
  }

  static dynamic getData(String? key) {
    return _pref!.get(key ?? '');
  }

  static Future<bool> removeData(String? key) async {
    return await _pref!.remove(key ?? '');
  }
}
