class DateHerlpers {
  static String? weekdayName(int weekDay) {
    const Map<int, String> weekdayName = {
      1: "Monday",
      2: "Tuesday",
      3: "Wednesday",
      4: "Thursday",
      5: "Friday",
      6: "Saturday",
      7: "Sunday"
    };
    return weekdayName[weekDay];
  }

  static DateTime getFirstSaturday(DateTime date) {
    if (date.weekday == 6) return date;
    DateTime newDate = DateTime(date.year, date.month, date.day + 1);
    return getFirstSaturday(newDate);
  }

  //***** */
  static DateTime getFirstSunday(DateTime date) {
    if (date.weekday == 7) return date;
    DateTime newDate = DateTime(date.year, date.month, date.day + 1);
    return getFirstSunday(newDate);
  }

  static DateTime getFirstThursday(DateTime date){
    if(date.weekday == 4) return date;
    DateTime newDate = DateTime(date.year, date.month, date.day + 1);
    return getFirstThursday(newDate);
  }


  ///***** */

  static List<DateTime> getFullWeek({DateTime? date}) {
    List<DateTime> days = [];

    date ??= getFirstSaturday(date ?? DateTime.now());
   if (date.difference(DateTime.now()) > const Duration(days: 2)) {
      date = date.subtract(const Duration(days: 7));
    }
    days.clear();
    for (int i = 0; i < 7; i++) {
      DateTime newDate = DateTime(date.year, date.month, date.day + i);

      days.add(newDate);
    }
    return days;
  }

  static List<DateTime> getWeekDates(DateTime date) {


    DateTime firstDayOfWeek = getFirstSunday(date);

   
    List<DateTime> weekDates = [];

   if (firstDayOfWeek.difference(date) > const Duration(days: 2)) {
      firstDayOfWeek = firstDayOfWeek.subtract(const Duration(days: 7));
    }
    
    for (int i = 0; i < 7; i++) {
      weekDates.add(firstDayOfWeek.add(Duration(days: i)));
    }

    return weekDates;
  }

  static DateTime getFirstDayOfWeek({DateTime? date}) =>
      getFullWeek(date: date).first;

  static DateTime getLastDayOfWeek({DateTime? date}) =>
      getFullWeek(date: date).last;
}
