import 'dart:developer';
import 'package:flutter_downloader/flutter_downloader.dart';
import 'package:firebase_core/firebase_core.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:provider/provider.dart';
import '../../../../../../core/lang/app_language.dart';
import '../../../../../../core/local%20storage/local_storage.dart';
import '../../../../../../core/network/firebaseApi.dart';
import '../../../../../../core/routing/routing_manager.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/auth/presentation/screens/splash_screen.dart';
import '../../../../../../features/exam/business_logic/result_controller.dart';
import '../../../../../../features/lms/business_logic/lms_controller.dart';
import '../../../../../../features/lms/business_logic/quizController.dart';
import '../../../../../../features/new_purchase/buisness_logic/new_purchase_controller.dart';
import '../../../../../../features/notification/business_logic/notification_controller.dart';
import '../../../../../../features/purchase/purchase_notifier.dart';
import '../../../../../../features/wallet/business_logic/wallet_controller.dart';
import '../../../../../../features/weekly_class/business_logic/new_weekly_class_controller.dart';
import '../../../../../../features/weekly_class/business_logic/weekly_class_controller.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'core/lang/app_language_controller.dart';
import 'features/calender/business_logic/calender_controller.dart';
import 'features/exam/business_logic/exam_controller.dart';
import 'features/home/business_logic/home_controller.dart';
import 'features/home/common/changeIndexNotifier.dart';
import 'features/home/presentation/screens/mainScreen.dart';
import 'features/notes/business_logic/note_controller.dart';
import 'features/restaurant/business_logic/restaurant_controller.dart';
import 'firebase_options.dart';

SharedPreferences? sharepref;

Future<void> main() async {
  WidgetsFlutterBinding.ensureInitialized(); // Required to use asynchronous code in main()
 
  await LocalStorage.init();
  log('message ${LocalStorage().userToken}');
  Provider.debugCheckInvalidValueType = null;
  sharepref = await SharedPreferences.getInstance();

   await FlutterDownloader.initialize(
    debug: true, 
    ignoreSsl: true, 
  );

  try{
    // await Firebase.initializeApp(
    //   options: DefaultFirebaseOptions.currentPlatform,
    // );
    if (Firebase.apps.isEmpty) {
      await Firebase.initializeApp(
        options: DefaultFirebaseOptions.currentPlatform,
      );
    }
    await FirebaseApi().initNotifications();
  }catch(e){
    print("the Error is from firebase $e");
  }

  runApp(
    MultiProvider(
        providers:[
          ChangeNotifierProvider(create: (context)=> ChangeIndexNotifier()),
          Provider(create: (context)=> const MainScreen())
        ],
      child: const MyApp(),
    )
  );
}

class MyApp extends StatelessWidget {
  const MyApp({super.key});
  // LocalStorage storage = LocalStorage();
  // This widget is the root of your application.
  @override
  Widget build(BuildContext context) {
    log("main ${LocalStorage().userToken}");
    Get.put(WeeklyClassController());
    Get.put(AuthController());
    Get.put(CalenderController());
    Get.put(HomeController());
    Get.put(NoteController());
    Get.put(ExamController());
    Get.put(RestaurantController());
    Get.put(NewWeeklyClassController());
    Get.put(LmsController());
    Get.put(QuizController());
    Get.put(WalletController());
    Get.put(PurchaseNotifier());
    Get.put(ResultController());
    Get.put(NewPurchaseController());
    Get.put(ResultController());
    Get.put(NotificationController());
    AppLanguageController controller = Get.put(AppLanguageController());
    // AuthController authController = Get.find<AuthController>();
    return GetMaterialApp(
      debugShowCheckedModeBanner: false,
      getPages: RoutingManager.pages,
      locale: controller.intialLang,
      translations: AppLanguage(),
      home: SplashScreen(),
    );
  }
}
