import 'package:fl_chart/fl_chart.dart';
import 'package:flutter/material.dart';

class FlChart extends StatelessWidget {
  const FlChart({super.key});
  final double value = 80;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: Column(
        children: [
          SizedBox(
            height: 200,
            width: 200,
            child: PieChart(PieChartData(centerSpaceRadius: 40,
                // centerSpaceColor: Colors.pink,

                sections: [
                  PieChartSectionData(

                      // badgeWidget: Center(child: Text(value.toString()),),
                      value: value,
                      title: value.toInt().toString(),
                      color: Colors.blue,
                      radius: 5,
                      titlePositionPercentageOffset: 0,
                      showTitle: true,
                      titleStyle: const TextStyle(
                          fontStyle: FontStyle.italic, inherit: true)),
                  PieChartSectionData(
                      showTitle: false,
                      value: 100 - value,
                      color: Colors.white,
                      radius: 6,
                      // titlePositionPercentageOffset: -5,
                      // showTitle: true,
                      titleStyle: const TextStyle(fontStyle: FontStyle.italic)),
                ])),
          ),
        ],
      ),
    );
  }
}
